<?php
include 'session.php';


$plans = mysqli_query($conn, "SELECT * FROM `plans` ORDER BY id DESC");


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plans</title>
    <link rel="stylesheet" href="css/table.css">
</head>

<style>

    .button {
        display: flex;
        justify-content: end;
        align-items: center;
    }

    .button a {
        padding: 10px 20px;
        text-align: center;
        width: 120px;
        cursor: pointer;
        background-color: var(--color-primary);
        color: white;
        border-radius: 10px;
        margin: 20px;
    }
    
    img{
        border-radius:10px !important;
        width:100px !important;
        height:auto !important;
    }
    

</style>

<body>
    <?php include_once('includes/header.php'); ?>

    <div class="button">
        <a href="plans_add.php">Add Plan</a>
    </div>

    <!-- =======================User LIST================ -->

    <table>

        <tr>
            <th>ID</th>
            <th>Logo</th>
            <th>Gateway</th>
            <th>Points</th>
            <th>Amount</th>
            <th>Action</th>

        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($plans)) {

            $id = $r['id'];
            $type = $r['type'];
            $points = $r['points'];
            $amount = $r['money'];
            $cover = $r['cover'];
            $status = $r['status'];

        ?>
            <tr>
                <td><?php echo $id ?></td>
                
                <td><img src="<?php echo $cover ?>"></td>
                
                <td><?php echo $type ?></td>
                
                
                <td><?php echo $points ?></td>
                <td><?php echo $amount ?></td>
               
                
                  <td id="actions">
                        <a href="plans_edit.php?id=<?php echo $id ?>"><i class="fa fa-edit"></i></a>
                        <a href="" onclick="deletePlan(<?php echo $id ?>)"><i class="fa fa-trash"></i></a>
                  </td>

            </tr>

        <?php
        }

        ?>

    </table>


    <!-- ================EXTRA JS===================== -->

    <script>
        function deletePlan(id) {
            if (window.confirm("Are you sure want to delete it")) {
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {

                        let res = xhttp.responseText;
                        if (res.includes("1")) {
                            location.reload();
                        } else {
                            alert("Failed To delete");

                        }
                    }
                };
                let url = "crud/delete_plan.php?id=" + id;
                xhttp.open("GET", url, true);
                xhttp.send();
            }
        }
        
    
        function disablePlan(id, check) {
            if (check.checked) {
                setDisable(id, "1");
            } else {
                setDisable(id, "0");
            }
        }

        function setDisable(id, status) {

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(xhttp.responseText);
                }
            };

            let url = "crud/crud_plan_disable.php?id=" + id + "&status=" + status;
            xhttp.open("GET", url, true);
            xhttp.send();
        }
 
        
    </script>



    <?php include_once('includes/footer.php'); ?>