<?php
include 'session.php';

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}
$per_page = 30;
$start = ($page - 1) * $per_page;

$payouts;
if (isset($_GET['q'])) {
    $search = $_GET['q'];

    $quser;
    if (is_numeric($search)) {
        $quser = "SELECT SELECT * FROM withdraw WHERE lower(id) LIKE lower('%$search%') && status!='SUCCESS' ORDER BY id ASC limit 100";
    } else {
        $quser = "SELECT SELECT * FROM withdraw WHERE lower(payment_on) LIKE lower('%$search%') && status!='SUCCESS'  ORDER BY id DESC limit 100";
    }

    $users = mysqli_query($conn, $quser);
} else {
    $search = "Search Here...";
    $payouts = mysqli_query($conn, "SELECT * FROM withdraw WHERE status!='SUCCESS' ORDER BY id DESC limit $start,$per_page");
}


// =====Pagination====

$totalPayments = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM `withdraw` WHERE status!='SUCCESS' "));
$totalPage = ceil($totalPayments / $per_page);



?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pending Payment</title>
    <link rel="stylesheet" href="css/table.css">
</head>

<style>
    input[type=search] {
        height: 40px;
        width: 70%;
        background-color: #e3e3e3;
        border-radius: 10px;
        margin: 10px auto;
        padding: 0px 10px;
        display: block;
        border: none;
        outline: none;
    }

    input[type=search]:focus {
        outline: 1px solid #e5e5e5;
    }
    
    
        .button {
        display: flex;
        justify-content: end;
        align-items: center;
    }

    .button a {
        padding: 10px 20px;
        text-align: center;
        width: max-content;
        cursor: pointer;
        background-color: var(--color-primary);
        color: white;
        border-radius: 10px;
        margin: 20px;
    }
    
</style>


<body>
    <?php include_once('includes/header.php'); ?>


    <div class="button">
        <a href="csv.php">Export CSV</a>
    </div>
    


    <!-- =======================User LIST================ -->


    <form action="" method="get" id="search_f">
        <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
    </form>
    
    <br>


    <table>

        <tr>
            <th>SN</th>
            <th>Name</th>
            <th>Payment ID</th>
            <th>Payment Type</th>
            <th>Points</th>
            <th>Amount</th>
            <th>Date</th>
            <th>Action</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($payouts)) {

            $id = $r['id'];
            $name = $r['name'];
            $payment_on = $r['payment_id'];
            $type = $r['type'];
            $points = $r['point'];
            $amount = $r['amount'];
            $date = $r['date'];
            $status = $r['status'];
        ?>
            <tr>
                <td><?php echo $id; ?></td>
                <td><?php echo $name; ?></td>
                <td><?php echo $payment_on; ?></td>
                <td><?php echo $type; ?></td>
                <td><?php echo $points; ?></td>
                <td><?php echo $amount; ?></td>
                <td><?php echo date("d-m-Y", strtotime($date)); ?></td>
                <?php
                if ($status != "SUCCESS") {
                ?>
                    <td id="actions">
                        <input type="checkbox" onclick="markPaid('<?php echo $id; ?>',this)" id="status">
                        <a href="view_profile.php?id=<?php echo $r['uid']; ?>"><i class="fa fa-user"></i></a>
                    </td>
                <?php
                } else {
                ?>
                    <td id="actions">
                        <input type="checkbox" onclick="markPaid('<?php echo $id ?>',this)" id="status" checked>
                        <a href="view_profile.php?id=<?php echo $r['uid']; ?>"><i class="fa fa-user"></i></a>
                    </td>

                <?php
                }
                ?>

            </tr>

        <?php
        }
        ?>
    </table>
    <!-- ===============Pagination=============== -->

    <div class="pagination">
        <a href="<?php
                    if ($page > 1) {
                        echo "?page=" . ($page - 1);
                    }
                    ?>">Pre</a>
        <?php
        for ($i = 1; $i <= $totalPage; $i++) {
            if ($i == $page) {
                echo "<a href='?page=" . $i . "' class='active'>" . $i . "</a>";
            } else {
                echo "<a href='?page=" . $i . "'>" . $i . "</a>";
            }
        ?>
        <?php
        }
        ?>
        <a href="<?php

                    if ($page < $totalPage) {
                        echo "?page=" . ($page + 1);
                    }
                    ?>">Next</a>
    </div>

    <!-- ================EXTRA JS===================== -->

    <script>
        function markPaid(id, check) {

            let msg = "Are you sure want to mark this user as Un-Paid";
            if (check.checked) {
                msg = "Are you sure want to mark this user as Paid";
            } else {
                msg = "Are you sure want to mark this user as Un-Paid";
            }

            if (window.confirm(msg)) {
                if (check.checked) {
                    setPaid(id, "1");
                } else {
                    setPaid(id, "0");
                }
            } else {
                if (check.checked) {
                    check.checked = false;
                } else {
                    check.checked = true;
                }
            }
        }

        function setPaid(id, status) {

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(xhttp.responseText);
                }
            };
            let url = "crud/crud_paid.php?id=" + id + "&status=" + status;
            xhttp.open("GET", url, true);
            xhttp.send();
        }
    </script>

    <?php include_once('includes/footer.php'); ?>