<?php
include 'session.php';

$slider = mysqli_query($conn, "SELECT * FROM `sliders` ORDER BY id DESC");

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Slider</title>
    <link rel="stylesheet" href="css/table.css">
</head>

<style>
    #cover {
        height: 120px;
        width: auto;
        border-radius: 10px;
    }

    .button {
        display: flex;
        justify-content: end;
        align-items: center;
    }

    .button a {
        padding: 10px 20px;
        text-align: center;
        width: 120px;
        cursor: pointer;
        background-color: var(--color-primary);
        color: white;
        border-radius: 10px;
        margin: 20px;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>

    <div class="button">
        <a href="slider_add.php">Add Sliders</a>
    </div>
    </div>

    <table>

        <tr>
            <th>ID</th>
            <th>Type</th>
            <th>Cover</th>
            <th>Actions</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($slider)) {

            $id = $r['id'];
            $type = $r['type'];
            $value = $r['value'];
            $image = $r['cover'];

        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><a href="<?php echo $value ?>" target="_blank"><?php echo $type ?></a></td>
                <td><img src="<?php echo $image ?>" id="cover"></td>

                <td id="actions">
                    <a href="" onclick="deleteSlider('<?php echo $id ?>')"><i class="fa fa-trash"></i></a>
                </td>

            </tr>

        <?php
        }

        ?>

    </table>


    <script>
        function deleteSlider(id) {
            if (window.confirm("Are you sure want to delete it")) {
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {

                        let res = xhttp.responseText;
                        if (res.includes("1")) {
                            location.reload();
                        } else {
                            alert("Failed To delete");

                        }
                    }
                };
                let url = "crud/delete_slider.php?id=" + id;
                xhttp.open("GET", url, true);
                xhttp.send();
            }
        }
    </script>

    <?php include_once('includes/footer.php'); ?>