<?php
include 'session.php';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
</head>

<style>
    .dashboard {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
        grid-auto-rows: 100px;
        grid-gap: 20px;
        height: 100vh;
    }

    .dashboard a {
        color: var(--color-primary);
        box-shadow: 3px 5px 5px 0px rgba(0, 0, 0, 0.05), 0 0 0 2px rgba(0, 0, 0, 0.05);
        height: 100px;
        border-radius: 20px;
        cursor: pointer;
        display: flex;
        align-items: center;
        align-content: center;
        padding: 0px 10px;
    }

    .dashboard a i {
        color: #FFF;
        font-size: 18px;
        display: inline-block;
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-radius: 50%;
        background-color: var(--color-primary);
    }

    .dashboard a .right div {
        margin: 5px 0 5px 20px;
        font-size: 18px;
    }

    .dashboard a .right .text {
        font-size: 14px;
        color: #4f5c72;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>


    <?php

    $totalusers = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM users"));
    $totalrequest = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM withdraw WHERE status = 0"));
    $totalslider = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM slider"));
    $totalfeedback = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM contact WHERE unread = 0"));

    ?>

    <div class="dashboard">

        <a href="users.php">
            <i class="fas fa-users"></i>

            <div class="right">
                <div><?php echo $totalusers ?></div>
                <div class="text"> Users</div>
            </div>

        </a>

        <a href="pending_payout.php">
            <i class="fa-solid fa-building-columns"></i>

            <div class="right">
                <div><?php echo $totalrequest ?></div>
                <div class="text">Payment Request</div>
            </div>
        </a>

        <a href="feedback.php">
            <i class="fa fa-headset"></i>

            <div class="right">
                <div><?php echo $totalfeedback ?></div>
                <div class="text">Feedbacks</div>
            </div>
        </a>

        <a href="slider.php">
            <i class="fa fa-images"></i>
            <div class="right">
                <div><?php echo $totalslider ?></div>
                <div class="text">Sliders</div>
            </div>
        </a>

        <a href="notification.php?to=chikuai">
            <i class="fas fa-bell"></i>

            <div class="right">
                <div></div>
                <div class="text">Notification</div>
            </div>
        </a>


        <a href="settings.php">
            <i class="fas fa-gears"></i>

            <div class="right">
                <div></div>
                <div class="text">Settings</div>
            </div>
        </a>


    </div>



    <?php include_once('includes/footer.php'); ?>